function get-available-updates([switch]${only-mandatory}=$false){
    $updater = new-object -com "Microsoft.Update.Session"
    $searcher = $updater.CreateupdateSearcher()
    
    
    
    $updates = $searcher.Search("ISInstalled=0 and Type='software'").updates
    
    #vi inkluderer ikke 
    if(${only-mandatory}) {
        return ($updates | where { $_.IsMandatory})
    }
    
    return $updates
    # | select * -exclude EulaText

}

function install-updates(){
     #bearbeida fra http://blogs.technet.com/jamesone/archive/2009/01/27/managing-windows-update-with-powershell.aspx
     $resultcode= @{0="Not Started"; 1="In Progress"; 2="Succeeded"; 3="Succeeded With Errors"; 4="Failed" ; 5="Aborted" }

     $updateSession = new-object -com "Microsoft.Update.Session"
      
     write-progress -Activity "Updating" -Status "Sjekker oppdateringer"  
     $updates=$updateSession.CreateupdateSearcher().Search($criteria).Updates

     if ($Updates.Count -eq 0)  {
      "Ingen oppdateringer tilgjengelig."
     } else { 

           $downloader = $updateSession.CreateUpdateDownloader()   
           $downloader.Updates = $Updates  

            write-progress -Activity 'Updating' -Status "Laster ned $($downloader.Updates.count) oppdateringer" 
           $Result= $downloader.Download()  

           if (($Result.Hresult -eq 0) and (($result.resultCode eq 2) -or ($result.resultCode eq 3)) ) {

               $updatesToInstall = New-object -com "Microsoft.Update.UpdateColl"

               $Updates | where {$_.isdownloaded} | foreach-Object {$updatesToInstall.Add($_) | out-null }
               $installer = $updateSession.CreateUpdateInstaller()
               $installer.Updates = $updatesToInstall


               write-progress -Activity 'Updating' -Status "Installerer $($Installer.Updates.count) oppdateringer"
                $installationResult = $installer.Install()
                $Global:counter=-1
                $installer.updates | Format-Table -autosize -property Title,EulaAccepted,@{label='Result';
                                       expression={$ResultCode[$installationResult.GetUpdateResult($Global:Counter++).resultCode ] }} 
           
            } 
    }
}


#get-available-updates 
#get-available-updates -only-mandatory