<?php
function l($str=null) { return;
  static $log = array();
  
  if(is_null($str)) {
    echo "<pre>" . implode("\n",$log) . '</pre>';
  }
  
  $log[] = $str;
  
  
}

function to_utf8($s){
  return mb_convert_encoding($s, "utf-8");
  //return utf8_decode($s);
  
}


function run_powershell_file($file){
    $f =  htmlentities($file);
    
    $dir  = 'C:/xampp/htdocs/powershell/';
    $cache = $dir . 'cache/' . $file . '.cache.txt';
    $file = $dir. $file;
    
    $old = getcwd();
    chdir($dir);
    
    $cmd = "powershell.exe -file \"$file\"";
    
    
    if(file_exists($file)) {
        $contents = shell_exec($cmd);
        file_put_contents($cache, $contents);
	//$contents = '<span class="script-label">Kjører nå fila <a href="powershell/' . $f    . '">' . $f .  '</a>:</span>' .
	
        $contents = '<span class="script-label">(<a href="powershell/' . $f    . '">Se kilde for fila ' . $f .  '</a>)</span>' .
        to_utf8($contents, "utf-8");
    } else {
        $contents = "Fila " . $f . ' kunne ikke leses';
    }
    chdir($old);
    return $contents;
    
}

function get_powershell_output($file, $id,$cacheTime=30) {
    $id = 'ps-' . $id;
    
    $dir  = 'C:/xampp/htdocs/powershell/';
    $cache = $dir . 'cache/' . $file . '.cache.txt';
    
    
    $old = getcwd();
    chdir($dir);
    
    $f = htmlentities($file);
    
    $contents = "\n\n" . '<div id="' . $id . '" class="generated-table ' . $f . '">' . "\n";
    
   
    
    if(is_file($cache)) {
         
        //update cache in 30 seconds. could be problematic if multiple users view the page simultaniously
        $contents .= to_utf8(file_get_contents($cache));
         
        
    } else {
        //update async now!
        $cacheTime = 1;
        $contents .= '<div class="placeholder">Innhold hentes..</div>';
    }
    $contents .= '<span class="script-label">(<a href="powershell/' . $f    . '">Se kilde for fila ' . $f .  '</a>)</span>';
    $contents .= "\n</div>\n\n";
    
    chdir($old);
    
    return array($contents, $cacheTime, $id);
}

if(isset($_REQUEST['json-update'], $_REQUEST['filename'])) {
    //header('Content-type: application/json');
    $file = basename($_REQUEST['filename']);
    $contents = run_powershell_file($file);
    echo $contents;
    
    exit;
}

$async_updates = array();

$site = isset($_GET["site"]) ? ( (string)$_GET["site"] ) : "";


if($site == "" || $site == "default") {
    $site = "default";
    
} elseif($site == "email") {
    $mail = "get-mail-accounts.ps1";
    list($mailContents, $mailCache, $id) =  get_powershell_output($mail, "mail");

    $async_updates[] = array($id, $mailCache, $mail);
} elseif($site == "server-statistics") {

    $stats  = "get-server-stats.ps1";
    list($statsContents, $statsCache, $id) =  get_powershell_output($stats, "stats", 5);
    
    $async_updates[] = array($id, $statsCache, $stats);

} elseif($site == "virtual-machines") {
    
}

?><!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html id="no-js" xml:lang="no" xmlns="http://www.w3.org/1999/xhtml" lang="no"><head>


	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title>Mofoberg Systems kontrollpanel</title>
	<script>document.documentElement.id = "js"; </script>
	<link rel="stylesheet" href="Filer_for_Mofoberg%20Systems/reset.css">
	<link rel="stylesheet" href="Filer_for_Mofoberg%20Systems/main.css">
</head><body>
	<div id="page">
		<div id="page-top">

			
			<h1>Bachelorprosjektet vår 2010</h1><br>
			<h2>Gruppe 6E - kontrollpanel</h2>
		</div>
		<div id="page-tabs">
			<ul>
				<li><a href="index.php?site=default" <?php if($site == "default") echo 'class="active"';?>><img src="activity_monitor.png" /> Hjem</a></li>

				<li><a href="index.php?site=email" <?php if($site == "email") echo 'class="active"';?>><img src="address_book_32.png" /> Eposter</a></li>
				<li><a href="index.php?site=server-statistics" <?php if($site == "server-statistics") echo 'class="active"';?>><img src="chart_32.png" /> Statistikk</a></li>
				<li><a href="index.php?site=virtual-machines" <?php if($site == "virtual-machines") echo 'class="active"';?>><img src="vms_32.png" /> Virtuelle maskiner</a></li>
			</ul>
			<div class="clear-both"></div>
		</div>

		<div id="page-content">
                    <?php if($site == "default"):?>
			<h2>Velkommen!</h2><p class="info">Dette er nettsidene til Gruppe 6E i
 bachelorprosjektet vår 2010 - kontrollpanel edition!</p>
		    <?php endif; ?>
                    
			<div class="ulrow">
                                <?php if($site == "default"):?>
                                    <p class="info">Dette er startsida for kontrollpanelet. Overfor vil du se en del faner som du kan trykke. Disse vil bringe deg videre til mer detaljert informasjon</p>
                                    
                                    <p class="info">Dette kontrollpanelet bygger på php, powershell og powershellmodulene for kommunikasjon med Exchange, SCVMM og Active Directory. Alle scriptene kan finnes <a href="powershell">under mappa "powershell"</a></p>
                                <?php endif; ?>
                                
                                <?php if($site == "email"):?>
				<h2>Mailkontoer</h2>
                                <p class="info">Nedenfor ser du ei liste over alle brukere i domenet som har en aktiv mailadresse</p>
				<div class="generated-table">
				<?php echo $mailContents ?>
				</div>
                                <?php endif; ?>
                                
				<?php if($site == "server-statistics"):?>
				<div class="generated-table">
				<?php echo $statsContents; ?>
				</div>
                                <?php endif; ?>
				
				
				
			</div>
			
		        
			<div id="page-footer">
			  Gruppemedlemmer: 
			  <a href="mailto:mariusfo@stud.hist.no">Marius Foss</a> og 
<a href="mailto:biberg@stud.hist.no">Bjørn Inge Berg</a>			  
		        </div>

		</div>
	<script src="http://code.jquery.com/jquery-latest.js"></script>
        <script>var asyncUpdates = <?php echo json_encode($async_updates); ?>;</script>
        <script src="Filer_for_Mofoberg%20Systems/main.js"></script>
	</div>
</body></html>